%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%   GUI for capacitors with inhomogeneous dielectrics


function varargout = capCalc3(varargin)
% CAPCALC3 M-file for capCalc3.fig
%      CAPCALC3, by itself, creates a new CAPCALC3 or raises the existing
%      singleton*.
%
%      H = CAPCALC3 returns the handle to a new CAPCALC3 or the handle to
%      the existing singleton*.
%
%      CAPCALC3('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in CAPCALC3.M with the given input arguments.
%
%      CAPCALC3('Property','Value',...) creates a new CAPCALC3 or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before capCalc3_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to capCalc3_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help capCalc3

% Last Modified by GUIDE v2.5 03-Jun-2010 15:25:14

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @capCalc3_OpeningFcn, ...
                   'gui_OutputFcn',  @capCalc3_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before capCalc3 is made visible.
function capCalc3_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to capCalc3 (see VARARGIN)
% Import the figure of the current structure

handles.ppCapD = imread('ppCapD.png');
handles.ppCapE = imread('ppCapE.png');
handles.sphCapCon = imread('sphCapCon.png');
handles.sphCapHalf = imread('sphCapHalf.png');
handles.twlCoat = imread('twlCoat.png');
% Set the current data value.

set(handles.uipanel1,'Visible','off');
set(handles.axes1,'Visible','off');
% Choose default command line output for capCalc3
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

set(0,'units','inches');
screenSize = get(0,'ScreenSize');
set(hObject,'Units','inches','Position',[screenSize(3)/2-(6.6563/2),screenSize(4)/2-(5.5417/2),6.6563,5.5417]);

% UIWAIT makes capCalc3 wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = capCalc3_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on selection change in popupmenu1.
function popupmenu1_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global i;
% Set current data to the selected data set.
switch get(handles.popupmenu1,'Value')  
case 1
   set(handles.uipanel1,'Visible','off');
   cla reset; axis off;
case 2
   handles.current_data = handles.ppCapD;
   imshow(handles.current_data);
   set(handles.edit4,'Visible','on');
   set(handles.edit5,'Visible','on');
   set(handles.text2,'String','d1:');
   set(handles.text3,'String','d2:');
   set(handles.text4,'String','S:');
   set(handles.text5,'Visible','on','String','EPSR1:');
   set(handles.text6,'Visible','on','String','EPSR2:');
   set(handles.text7,'String','(mm)');
   set(handles.text8,'String','(mm)');
   set(handles.text9,'Visible','on','String','(mm^2)');
   set(handles.text12,'String','(pF)');
   set(handles.uipanel1,'Visible','on');
   i = 1;
case 3 
   handles.current_data = handles.ppCapE;
   imshow(handles.current_data);
   set(handles.edit4,'Visible','on');
   set(handles.edit5,'Visible','on');
   set(handles.text2,'String','S1:');
   set(handles.text3,'String','S2:');
   set(handles.text4,'String','d:');
   set(handles.text5,'Visible','on','String','EPSR1:');
   set(handles.text6,'Visible','on','String','EPSR2:');
   set(handles.text7,'String','(mm^2)');
   set(handles.text8,'String','(mm^2)');
   set(handles.text9,'Visible','on','String','(mm)');
   set(handles.text12,'String','(pF)');
   set(handles.uipanel1,'Visible','on');
   i = 2;
case  4
   handles.current_data = handles.sphCapCon;
   imshow(handles.current_data);
   set(handles.edit4,'Visible','on');
   set(handles.edit5,'Visible','on');
   set(handles.text2,'String','a:');
   set(handles.text3,'String','b:');
   set(handles.text4,'String','c:');
   set(handles.text5,'Visible','on','String','EPSR1:');
   set(handles.text6,'Visible','on','String','EPSR2:');
   set(handles.text7,'String','(mm)');
   set(handles.text8,'String','(mm)');
   set(handles.text9,'Visible','on','String','(mm)');
   set(handles.text12,'String','(pF)');
   set(handles.uipanel1,'Visible','on');
   i = 3;
case 5 
   handles.current_data = handles.sphCapHalf;
   imshow(handles.current_data);
   set(handles.edit4,'Visible','on');
   set(handles.text5,'Visible','on');
   set(handles.text2,'String','a:');
   set(handles.text3,'String','b:');
   set(handles.text4,'String','EPSR1:');
   set(handles.text5,'String','EPSR2:');
   set(handles.text6,'Visible','off');
   set(handles.edit5,'Visible','off');
   set(handles.text7,'String','(mm)');
   set(handles.text8,'String','(mm)');
   set(handles.text9,'Visible','off');
   set(handles.text12,'String','(pF)');
   set(handles.uipanel1,'Visible','on');
   i = 4;
case 6 
   handles.current_data = handles.twlCoat;
   imshow(handles.current_data);
   set(handles.text2,'String','a:');
   set(handles.text3,'String','d:');
   set(handles.text4,'String','EPSR:');
   set(handles.text5,'Visible','off');
   set(handles.text6,'Visible','off');
   set(handles.edit4,'Visible','off');
   set(handles.edit5,'Visible','off');
   set(handles.text7,'String','(mm)');
   set(handles.text8,'String','(mm)');
   set(handles.text9,'Visible','off');
   set(handles.text12,'String','(pF/m)');
   set(handles.uipanel1,'Visible','on');
   i = 5;

end
global ready;
global var;
 ready = [0 0 0 0 0];
 var = [0 0 0 0 0];
 set(handles.pushbutton1,'Enable','off');
 set(handles.edit1,'String','');
 set(handles.edit2,'String','');
 set(handles.edit3,'String','');
 set(handles.edit4,'String','');
 set(handles.edit5,'String','');
 set(handles.text11,'String','');

% Hints: contents = get(hObject,'String') returns popupmenu1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu1


% --- Executes during object creation, after setting all properties.
function popupmenu1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
global ready;
 ready = [0 0 0 0 0];
global var;
 var = [0 0 0 0 0];



function edit1_Callback(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit1 as text
%        str2double(get(hObject,'String')) returns contents of edit1 as a double

% --- Executes during object creation, after setting all properties.
handles.edit1 = str2double(get(hObject,'String'));
 global ready;
 global var;
 global i;
 if i == 4;
     if (isnan(handles.edit1));
     msgbox('Invalid input','Error');
     ready(1)= 0;
else
    ready(1)= 1;
    var(1) = handles.edit1;
end;
if (ready == [1 1 1 1 0])
     set(handles.pushbutton1,'Enable','on');
 else
    set(handles.pushbutton1,'Enable','off'); 
end;
 else if i == 5;
         if (isnan(handles.edit1));
     msgbox('Invalid input','Error');
     ready(1)= 0;
else
    ready(1)= 1;
    var(1) = handles.edit1;
end;
if (ready == [1 1 1 0 0])
     set(handles.pushbutton1,'Enable','on');
 else
    set(handles.pushbutton1,'Enable','off'); 
end;
     else 
         if (isnan(handles.edit1));
     msgbox('Invalid input','Error');
     ready(1)= 0;
else
    ready(1)= 1;
    var(1) = handles.edit1;
end;
if (ready == [1 1 1 1 1])
     set(handles.pushbutton1,'Enable','on');
 else
    set(handles.pushbutton1,'Enable','off'); 
end;
     end;
 end

 
         

% --- Executes during object creation, after setting all properties.
function edit1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit2_Callback(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit2 as text
%        str2double(get(hObject,'String')) returns contents of edit2 as a double

% --- Executes during object creation, after setting all properties.
handles.edit2 = str2double(get(hObject,'String'));
 global ready;
 global var;
 global i;
 if i == 4;
     if (isnan(handles.edit2));
     msgbox('Invalid input','Error');
     ready(2)= 0;
else
    ready(2)= 1;
    var(2) = handles.edit2;
end;
if (ready == [1 1 1 1 0])
     set(handles.pushbutton1,'Enable','on');
 else
    set(handles.pushbutton1,'Enable','off'); 
end;
 else if i == 5;
         if (isnan(handles.edit2));
     msgbox('Invalid input','Error');
     ready(2)= 0;
else
    ready(2)= 1;
    var(2) = handles.edit2;
end;
if (ready == [1 1 1 0 0])
     set(handles.pushbutton1,'Enable','on');
 else
    set(handles.pushbutton1,'Enable','off'); 
end;
     else 
         if (isnan(handles.edit2));
     msgbox('Invalid input','Error');
     ready(2)= 0;
else
    ready(2)= 1;
    var(2) = handles.edit2;
end;
if (ready == [1 1 1 1 1])
     set(handles.pushbutton1,'Enable','on');
 else
    set(handles.pushbutton1,'Enable','off'); 
end;
     end;
 end

% --- Executes during object creation, after setting all properties.
function edit2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit3_Callback(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit3 as text
%        str2double(get(hObject,'String')) returns contents of edit3 as a double
% --- Executes during object creation, after setting all properties.
handles.edit3 = str2double(get(hObject,'String'));
 global ready;
 global var;
 global i;
 if i == 4;
     if (isnan(handles.edit3));
     msgbox('Invalid input','Error');
     ready(3)= 0;
else
    ready(3)= 1;
    var(3) = handles.edit3;
end;
if (ready == [1 1 1 1 0])
     set(handles.pushbutton1,'Enable','on');
 else
    set(handles.pushbutton1,'Enable','off'); 
end;
 else if i == 5;
         if (isnan(handles.edit3));
     msgbox('Invalid input','Error');
     ready(3)= 0;
else
    ready(3)= 1;
    var(3) = handles.edit3;
end;
if (ready == [1 1 1 0 0])
     set(handles.pushbutton1,'Enable','on');
 else
    set(handles.pushbutton1,'Enable','off'); 
end;
     else 
         if (isnan(handles.edit3));
     msgbox('Invalid input','Error');
     ready(3)= 0;
else
    ready(3)= 1;
    var(3) = handles.edit3;
end;
if (ready == [1 1 1 1 1])
     set(handles.pushbutton1,'Enable','on');
 else
    set(handles.pushbutton1,'Enable','off'); 
end;
     end;
 end


% --- Executes during object creation, after setting all properties.
function edit3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit4_Callback(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit4 as text
%        str2double(get(hObject,'String')) returns contents of edit4 as a double

% --- Executes during object creation, after setting all properties.
handles.edit4 = str2double(get(hObject,'String'));
 global ready;
 global var;
 global i;
 if i == 4;
     if (isnan(handles.edit4));
     msgbox('Invalid input','Error');
     ready(4)= 0;
else
    ready(4)= 1;
    var(4) = handles.edit4;
end;
if (ready == [1 1 1 1 0])
     set(handles.pushbutton1,'Enable','on');
 else
    set(handles.pushbutton1,'Enable','off'); 
end;
 else 
         if (isnan(handles.edit4));
     msgbox('Invalid input','Error');
     ready(4)= 0;
else
    ready(4)= 1;
    var(4) = handles.edit4;
end;
if (ready == [1 1 1 1 1])
     set(handles.pushbutton1,'Enable','on');
 else
    set(handles.pushbutton1,'Enable','off'); 
end;
 end

% --- Executes during object creation, after setting all properties.
function edit4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit5_Callback(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit5 as text
%        str2double(get(hObject,'String')) returns contents of edit5 as a double

% --- Executes during object creation, after setting all properties.
handles.edit5 = str2double(get(hObject,'String'));
 global ready;
 global var;

 if (isnan(handles.edit5));
     msgbox('Invalid input','Error');
     ready(5)= 0;
else
    ready(5)= 1;
    var(5) = handles.edit5;
end;
if (ready == [1 1 1 1 1])
     set(handles.pushbutton1,'Enable','on');
 else
    set(handles.pushbutton1,'Enable','off'); 
end;
 
% --- Executes during object creation, after setting all properties.
function edit5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% --- Executes during object creation, after setting all properties.
global var;
global i;
EPS0 = 8.8542*10^(-12);
mm2m = 10^(-3);
mmsq2msq = 10^(-6);
if  i == 1; 
    d1 = var(1)*mm2m;
    d2 = var(2)*mm2m;
    S = var(3)*mmsq2msq;
    EPSR1 = var(4);
    EPSR2 = var(5);
    C = EPS0*EPSR1*EPSR2*S/(EPSR2*d1 + EPSR1*d2);
else if  i == 2;
        S1 = var(1)*mmsq2msq;
        S2 = var(2)*mmsq2msq;
        d = var(3)*mm2m;
        EPSR1 = var(4);
        EPSR2 = var(5);
        C = EPS0*(EPSR1*S1 + EPSR2*S2)/d;
    else if i == 3;  
            a = var(1)*mm2m;
            b = var(2)*mm2m;
            c = var(3)*mm2m;
            EPSR1 = var(4);
            EPSR2 = var(5);
            C = 4*pi*EPS0*((b-a)/(EPSR1*a*b) + (c-b)/(EPSR2*b*c))^(-1);
        else if  i == 4;   
                a = var(1)*mm2m;
                b = var(2)*mm2m;
                EPSR1 = var(3);
                EPSR2 = var(4);
                C = 2*pi*EPS0*(EPSR1 + EPSR2)*a*b/(b-a);
            else 
                a = var(1)*mm2m;
                d = var(2)*mm2m;
                EPSR = var(3);
                C = pi*(log(2)/(EPSR*EPS0) + log(d/(2*a))/EPS0)^(-1);
            end;
        end
    end
end
C = C*10^12;
set(handles.text11,'String',num2str(C,'%.4e'));
